/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.FieldProcessor;
import java.sql.SQLException;

public class UpgradeOrInstallFlag
implements FieldProcessor {
    protected String formatValueFromBoolean(boolean flagValue, WizardInteractorData data, JobProperties props) throws SQLException, ConnectionNotFoundException {
        return flagValue ? "upgrade" : "install";
    }

    @Override
    public boolean validateValue(String fieldValue) {
        String uppercaseValue = fieldValue.toUpperCase();
        return "UPGRADE".equals(uppercaseValue) || "INSTALL".equals(uppercaseValue);
    }

    @Override
    public String processFieldData(WizardInteractorData data, String fieldValue, JobProperties props) throws Exception {
        String uppercaseValue = fieldValue.toUpperCase();
        return this.formatValueFromBoolean("UPGRADE".equals(uppercaseValue), data, props);
    }
}

