/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.cmd;

import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.cmd.FieldProcessor;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;

public class SqlServerDatabaseFileDirectoryPath
implements FieldProcessor {
    @Override
    public String processFieldData(WizardInteractorData data, String fieldValue, JobProperties props) throws Exception {
        ConnectStringParse parseConnectString = new ConnectStringParse(fieldValue);
        String dbName = parseConnectString.getDatabase();
        String connectionString = props.getConnection(ConnectionClass.SYSADMIN);
        String sqlServerDatafilePath = this.getDatabaseFileDirectory(connectionString) + "\\";
        return sqlServerDatafilePath;
    }

    @Override
    public boolean validateValue(String fieldValue) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDatabaseFileDirectory(String connectionString) throws Exception {
        try (DatabaseConnection connection = null;){
            connection = new DatabaseConnection(connectionString);
            String string = SqlServerLogic.getMasterFileDirectory(connection);
            return string;
        }
    }
}

