/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.charconv;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.connection.DatabaseMetaData;
import com.primavera.database.common.job.JobListener;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.AbstractJob;
import com.primavera.database.tools.dbmt.charconv.RunCharConv;

public class CharConvBuilderJob
extends AbstractJob {
    private final String m_connectString;
    private final String m_srcCharset;
    private final String m_dstCharset;
    private final String m_tables;

    public CharConvBuilderJob(String connectstring, String srcCharset, String destCharset, String tables) {
        this.m_connectString = connectstring;
        this.m_srcCharset = srcCharset;
        this.m_dstCharset = destCharset;
        this.m_tables = tables;
    }

    @Override
    public boolean isIndeterminateProgress() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean doJob(JobListener listener, JobWatcher watcher) throws Exception {
        DatabaseConnection connection = new DatabaseConnection(this.m_connectString);
        DatabaseMetaData meta = new DatabaseMetaData();
        meta.setDatabaseConnection(connection);
        RunCharConv rcc = RunCharConv.getRunCharConv();
        rcc.setConnection(connection);
        rcc.setSourceCharset(this.m_srcCharset);
        rcc.setTargetCharset(this.m_dstCharset);
        rcc.setTableList(this.m_tables);
        try {
            if (!watcher.isContinue()) {
                boolean bl = false;
                return bl;
            }
            if (rcc.runCharsetConversion()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            connection.close();
            connection = null;
        }
    }

    public String toString() {
        return StringLocalizer.get("dbmt.charconversion.jobs.convertingcharacterset.name", new String[]{this.m_srcCharset, this.m_dstCharset});
    }
}

