/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.actions.FieldTester;
import com.primavera.database.tools.dbmt.actions.InteractorData;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.InteractorPageDef;
import com.primavera.database.tools.dbmt.actions.InvalidDialogField;
import com.primavera.database.tools.dbmt.actions.InvalidWizardField;
import com.primavera.database.tools.dbmt.actions.InvalidWizardPageData;
import com.primavera.database.tools.dbmt.actions.NextOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorDataDef;
import com.primavera.database.tools.dbmt.actions.WizardNavigationAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class WizardInteractorData {
    private final WizardInteractorDataDef m_def;
    private final Map<String, InteractorData> m_dataMap = new HashMap<String, InteractorData>();

    public WizardInteractorData(WizardInteractorDataDef def) {
        this.m_def = def;
        Map<String, InteractorPageDef> map = this.m_def.getDataDefMap();
        for (Map.Entry<String, InteractorPageDef> entry : map.entrySet()) {
            this.m_dataMap.put(entry.getKey(), new InteractorData(entry.getValue()));
        }
    }

    public boolean isCommit(String pageId) {
        return this.m_def.isCommitPage(pageId);
    }

    public Iterable<InteractorData> getPages() {
        return this.m_dataMap.values();
    }

    public String getName() {
        return StringLocalizer.get(this.m_def.getNameKey());
    }

    public String getDesc() {
        return StringLocalizer.get(this.m_def.getDescKey());
    }

    public InteractorData getPageData(String pageId) throws InvalidWizardPageData {
        InteractorData data = this.m_dataMap.get(pageId);
        if (data == null) {
            throw new InvalidWizardPageData(pageId);
        }
        return data;
    }

    public boolean hasStart() {
        return this.m_def.hasStart();
    }

    public String getStart() {
        return this.m_def.getStart();
    }

    public String getNextPage(String pageId) {
        NextOp nextOp = this.m_def.getForwardMap().get(pageId);
        if (nextOp == null) {
            return null;
        }
        return nextOp.findNextPage(this);
    }

    public boolean canFinish(String pageId) {
        return this.m_def.canFinish(pageId);
    }

    public Iterable<String> getNextDependencies(String pageId) {
        return this.m_def.getForwardDependencies(pageId);
    }

    public Iterable<FieldTester> getNextValidators(String pageId) {
        return this.m_def.getForwardValidators(pageId);
    }

    public String getValue(String pageId, String fieldId) throws InteractorDataError {
        InteractorData pageData = this.getPageData(pageId);
        if (pageData == null) {
            throw new InvalidWizardPageData(pageId);
        }
        try {
            return pageData.getValue(fieldId);
        }
        catch (InvalidDialogField e) {
            throw new InvalidWizardField(pageId, fieldId);
        }
    }

    public boolean canPrevious(String pageId) {
        return this.m_def.canPrevious(pageId);
    }

    public WizardNavigationAction getPageNext(String pageId) {
        return this.m_def.getPageNext(pageId);
    }

    public Set<String> getPageIds() {
        return this.m_def.getDataDefMap().keySet();
    }
}

