/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import java.util.ArrayList;
import java.util.Set;

public class VerifyROUserDoesNotExist
implements TransitionMap.TransitionValidator {
    private String[] m_users;
    private ConnectionClass m_connection;

    public VerifyROUserDoesNotExist(ConnectionClass connection, String[] users) {
        this.m_connection = connection;
        this.m_users = users;
    }

    @Override
    public String validate(WizardInteractorData data, JobProperties jobProps, String page) {
        Set<String> existingUsers;
        ArrayList<String> duplicateUserNames = new ArrayList<String>();
        try {
            if (new ConnectStringParse(jobProps.getConnection(this.m_connection)).getDbtype() == ServerType.SQLSERVER) {
                return null;
            }
        }
        catch (ConnectionNotFoundException e2) {
            e2.printStackTrace();
        }
        try {
            existingUsers = OracleLogic.getExistingUsers(jobProps.getConnection(ConnectionClass.SYSADMIN));
        }
        catch (ConnectionNotFoundException e1) {
            return e1.getClass().getSimpleName() + ": " + e1.getMessage() + " (" + e1.getLocalizedMessage() + ")";
        }
        try {
            for (String fieldId : this.m_users) {
                String fieldValue = data.getValue(page, fieldId).toLowerCase();
                if (!existingUsers.contains(fieldValue)) continue;
                duplicateUserNames.add(fieldValue);
            }
            if (!duplicateUserNames.isEmpty() && "FALSE".equalsIgnoreCase(data.getValue(page, "existingRO"))) {
                StringBuffer sbuf = new StringBuffer((String)duplicateUserNames.get(0));
                for (int i = 1; i < duplicateUserNames.size(); ++i) {
                    sbuf.append(", " + (String)duplicateUserNames.get(i));
                }
                return StringLocalizer.get("dbmt.error.install.oracle.usersexist", new String[]{data.getValue("connect_install_or", "instance"), sbuf.toString()});
            }
        }
        catch (Throwable e) {
            return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
        }
        return null;
    }
}

