/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class SetSSUpgradeExpDatabaseName
implements TransitionMap.TransitionOperation {
    private static final String EXPADMIN_PARAM_DATABASE_NAME = "expadm.ss.database_name";
    private final String m_pageId;
    private final String m_dbNameField;

    public SetSSUpgradeExpDatabaseName(String id, String nameField) {
        this.m_pageId = id;
        this.m_dbNameField = nameField;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        Object expSchema;
        Object productSuite = jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY);
        if (productSuite == ProductSuiteType.EXP && (expSchema = jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_UPGRADE_KEY)) == SchemaType.EXPADM) {
            jobProps.getScriptProperties().put(EXPADMIN_PARAM_DATABASE_NAME, data.getValue(this.m_pageId, this.m_dbNameField));
        }
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
    }
}

