/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.ProductInfo;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class SetPMPPMSchemaInfoListTransOp
implements TransitionMap.TransitionOperation {
    private final ApplicationContextLogic m_contextLogic;
    private final Map<String, String> m_valueMap = new HashMap<String, String>();

    public SetPMPPMSchemaInfoListTransOp(ApplicationContextLogic contextLogic, Map<String, String> valueMap) {
        this.m_contextLogic = contextLogic;
        this.m_valueMap.putAll(valueMap);
    }

    public SetPMPPMSchemaInfoListTransOp(ApplicationContextLogic contextLogic) {
        this(contextLogic, new HashMap<String, String>());
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        try {
            ProductSuiteType suiteType = (ProductSuiteType)((Object)jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY));
            SchemaType schemaType = SchemaType.valueOf(this.getPmProduct(data, jobProps));
            if (suiteType == ProductSuiteType.PPM && schemaType == SchemaType.PM) {
                schemaType = SchemaType.PPM;
            }
            jobProps.setJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY, (Object)schemaType);
        }
        catch (Exception e) {
            return e.getClass().getSimpleName() + ": " + e.getMessage() + " (" + e.getLocalizedMessage() + ")";
        }
        try {
            List<SchemaInfo> schemaTypes = this.getSchemaTypes(data, jobProps, jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY).toString());
            jobProps.setJobProperty(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY, schemaTypes);
        }
        catch (InvalidSelection e) {
            return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
        }
        return null;
    }

    protected abstract String getPmProduct(WizardInteractorData var1, JobProperties var2) throws InteractorDataError, Exception;

    protected abstract List<SchemaInfo> getSchemaTypes(WizardInteractorData var1, JobProperties var2, String var3) throws InteractorDataError, InvalidSelection, JobPropertyNotFound;

    protected ProductInfo getProductInfo() {
        List<ProductInfo> productInfoList = this.m_contextLogic.getApp().getSuiteInfo(this.getProductSuiteType());
        ProductInfo productInfo = null;
        for (ProductInfo info : productInfoList) {
            if (productInfo != null && productInfo.getVersion().compareTo(info.getVersion()) >= 0) continue;
            productInfo = info;
        }
        return productInfo;
    }

    protected abstract ProductSuiteType getProductSuiteType();

    protected String getMappedValue(String value) {
        String mappedValue = this.m_valueMap.get(value);
        if (mappedValue == null) {
            return value;
        }
        return mappedValue;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY);
        properties.clearJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY);
    }

    public ApplicationContextLogic getContextLogic() {
        return this.m_contextLogic;
    }

    protected class InvalidProductSelection
    extends InvalidSelection {
        private static final long serialVersionUID = 7446209903046859471L;

        protected InvalidProductSelection(String mappedValue, String rawValue) {
            super(mappedValue, rawValue);
        }

        @Override
        protected String getLocalizationKey() {
            return "dbmt.action.error.setschemainfotrans.product.notfound";
        }
    }

    protected class InvalidProductOptionSelection
    extends InvalidSelection {
        private static final long serialVersionUID = -6807835450841341496L;

        protected InvalidProductOptionSelection(String mappedValue, String rawValue) {
            super(mappedValue, rawValue);
        }

        @Override
        protected String getLocalizationKey() {
            return "dbmt.action.error.setschemainfotrans.productoption.notfound";
        }
    }

    protected abstract class InvalidSelection
    extends Exception {
        protected final String m_mappedValue;
        protected final String m_rawValue;

        protected InvalidSelection(String mappedValue, String rawValue) {
            this.m_mappedValue = mappedValue;
            this.m_rawValue = rawValue;
        }

        protected abstract String getLocalizationKey();

        @Override
        public String getLocalizedMessage() {
            return StringLocalizer.get(this.getLocalizationKey(), new String[]{this.m_mappedValue, this.m_rawValue});
        }
    }
}

