/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.ServerType;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.InvalidSchemaType;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SetOracleConnectStringTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.Properties;

public class SetOracleExpConnectStringFromPageTransOp
extends SetOracleConnectStringTransOp {
    private final String m_connectionPage;
    private final String m_usersPage;

    public SetOracleExpConnectStringFromPageTransOp(String page, ConnectionClass connectionClass) {
        this(page, page, connectionClass);
    }

    public SetOracleExpConnectStringFromPageTransOp(String connectionPage, String usersPage, ConnectionClass connectionClass) {
        super(connectionClass, false, new Properties());
        this.m_connectionPage = connectionPage;
        this.m_usersPage = usersPage;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String currentPage, JobProperties properties) throws InteractorDataError {
        try {
            if (properties.getJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY) == ServerType.ORACLE) {
                return super.process(runner, data, currentPage, properties);
            }
        }
        catch (JobPropertyNotFound e) {
            return e.getLocalizedMessage();
        }
        return null;
    }

    @Override
    protected String getUsername(String page, WizardInteractorData data, JobProperties jobProps) throws DBMTException, InteractorDataError {
        Object schemaInfoObject = jobProps.getJobProperty(InstallSuiteOptionKeys.EXPEDITION_SCHEMA_KEY);
        if (schemaInfoObject == SchemaType.EXP || schemaInfoObject == SchemaType.EXPADM) {
            return data.getValue(this.m_usersPage, "username");
        }
        throw new InvalidSchemaType(schemaInfoObject);
    }

    @Override
    protected String getPassword(String page, WizardInteractorData data, JobProperties jobProps) throws DBMTException, InteractorDataError {
        Object schemaInfoObject = jobProps.getJobProperty(InstallSuiteOptionKeys.EXPEDITION_SCHEMA_KEY);
        if (schemaInfoObject == SchemaType.EXP || schemaInfoObject == SchemaType.EXPADM) {
            return data.getValue(this.m_usersPage, "password");
        }
        throw new InvalidSchemaType(schemaInfoObject);
    }

    @Override
    public String getPage(String currentPage) {
        return this.m_connectionPage;
    }
}

