/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.UknownSchemaTypeException;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class SetExpSchemaOptionsTransOp
implements TransitionMap.TransitionOperation {
    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        if (jobProps.getJobProperty(InstallSuiteOptionKeys.EXP_SCHEMA_NAME_STRING_KEY) != SchemaType.EXPADM) {
            return null;
        }
        jobProps.setJobProperty(InstallSuiteOptionKeys.EXP_OPTION_KEY, this.getSchemaType(data.getValue(page, "schema_options")));
        return null;
    }

    private Object getSchemaType(String string) throws DBMTException {
        if ("exp_same_instance".equalsIgnoreCase(string)) {
            return "PM_SAME_INSTANCE";
        }
        if ("exp_diff_instance".equalsIgnoreCase(string)) {
            return "PM_DIFF_INSTANCE";
        }
        if ("workflow_only".equalsIgnoreCase(string)) {
            return "WORKFLOW_ONLY";
        }
        throw new UknownSchemaTypeException(string);
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty(InstallSuiteOptionKeys.EXP_OPTION_KEY);
    }
}

