/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.ProductInfo;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class SetExpInstallSchemaInfoListTransOp
implements TransitionMap.TransitionOperation {
    private final ApplicationContextLogic m_context;

    public SetExpInstallSchemaInfoListTransOp(ApplicationContextLogic context) {
        this.m_context = context;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        try {
            List<SchemaInfo> schemaTypes = this.getSchemaTypes(data, jobProps, (SchemaType)((Object)jobProps.getJobProperty(InstallSuiteOptionKeys.EXP_SCHEMA_NAME_STRING_KEY)));
            jobProps.setJobProperty(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY, schemaTypes);
        }
        catch (InvalidSelection e) {
            return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
        }
        return null;
    }

    protected List<SchemaInfo> getSchemaTypes(WizardInteractorData data, JobProperties jobProps, SchemaType schema) throws InteractorDataError, InvalidSelection {
        ArrayList<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
        ProductInfo productInfo = this.getProductInfo();
        HashMap<SchemaType, SchemaInfo> schemaMap = new HashMap<SchemaType, SchemaInfo>();
        for (SchemaInfo info : productInfo.getAllSchemas()) {
            schemaMap.put(info.getSchemaType(), info);
        }
        schemas.add((SchemaInfo)schemaMap.get((Object)schema));
        return schemas;
    }

    protected ProductInfo getProductInfo() {
        List<ProductInfo> productInfoList = this.m_context.getApp().getSuiteInfo(ProductSuiteType.EXP);
        ProductInfo productInfo = null;
        for (ProductInfo info : productInfoList) {
            if (productInfo != null && productInfo.getVersion().compareTo(info.getVersion()) >= 0) continue;
            productInfo = info;
        }
        return productInfo;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.clearJobProperty(InstallSuiteOptionKeys.SCHEMA_INFO_LIST_KEY);
        properties.clearJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY);
    }

    public ApplicationContextLogic getContextLogic() {
        return this.m_context;
    }

    protected class InvalidProductSelection
    extends InvalidSelection {
        private static final long serialVersionUID = 7446209903046859471L;

        protected InvalidProductSelection(String mappedValue, String rawValue) {
            super(mappedValue, rawValue);
        }

        @Override
        protected String getLocalizationKey() {
            return "dbmt.action.error.setschemainfotrans.product.notfound";
        }
    }

    protected class InvalidProductOptionSelection
    extends InvalidSelection {
        private static final long serialVersionUID = -6807835450841341496L;

        protected InvalidProductOptionSelection(String mappedValue, String rawValue) {
            super(mappedValue, rawValue);
        }

        @Override
        protected String getLocalizationKey() {
            return "dbmt.action.error.setschemainfotrans.productoption.notfound";
        }
    }

    protected abstract class InvalidSelection
    extends Exception {
        protected final String m_mappedValue;
        protected final String m_rawValue;

        protected InvalidSelection(String mappedValue, String rawValue) {
            this.m_mappedValue = mappedValue;
            this.m_rawValue = rawValue;
        }

        protected abstract String getLocalizationKey();

        @Override
        public String getLocalizedMessage() {
            return StringLocalizer.get(this.getLocalizationKey(), new String[]{this.m_mappedValue, this.m_rawValue});
        }
    }
}

