/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SchemaValidationOptionKeys;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import java.sql.SQLException;

public class SetExistingPubUser
implements TransitionMap.TransitionOperation {
    private final String m_pageId;
    private final String m_fieldId;
    private final ConnectionClass m_connectionClassMaster;

    public SetExistingPubUser(ConnectionClass connection, String pageId, String fieldId) {
        this.m_connectionClassMaster = connection;
        this.m_pageId = pageId;
        this.m_fieldId = fieldId;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        String connectionString = jobProps.getConnection(this.m_connectionClassMaster);
        DatabaseConnection conn = null;
        try {
            conn = new DatabaseConnection(connectionString);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        String dbName = data.getValue(this.m_pageId, this.m_fieldId);
        String pubUser = SqlServerLogic.getPublicUser(conn, dbName);
        jobProps.getScriptProperties().setProperty("pm.ss.public_user", pubUser);
        jobProps.setJobProperty(SchemaValidationOptionKeys.PUBLIC_USER_NAME_KEY, pubUser);
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.getScriptProperties().remove("pm.ss.public_user");
    }
}

