/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SchemaValidationOptionKeys;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class SetExistingPrivPubPxrptUser
implements TransitionMap.TransitionOperation {
    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        String privUser = data.getValue(page, "privuser");
        jobProps.getScriptProperties().setProperty("pm.ss.privileged_user", privUser);
        jobProps.setJobProperty(SchemaValidationOptionKeys.PRIVILEGED_USER_NAME_KEY, privUser);
        String pubUser = data.getValue(page, "pubuser");
        jobProps.getScriptProperties().setProperty("pm.ss.public_user", pubUser);
        jobProps.setJobProperty(SchemaValidationOptionKeys.PUBLIC_USER_NAME_KEY, pubUser);
        String pxrptUser = data.getValue(page, "pxrptusername");
        jobProps.getScriptProperties().put("pm.or.odsplus_user", pxrptUser);
        jobProps.setJobProperty(SchemaValidationOptionKeys.PXRPT_USER_NAME_KEY, pxrptUser);
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.getScriptProperties().remove("pm.ss.privileged_user");
        properties.getScriptProperties().remove("pm.ss.public_user");
        properties.getScriptProperties().remove("pm.or.odsplus_user");
    }
}

