/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.EnumDataEntry;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.PageInitializerHelper;
import com.primavera.database.tools.dbmt.actions.SelectTypeDef;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleLogic;
import com.primavera.database.tools.dbmt.workflow.DatapumpJob;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SetExistingPXUsersSelectOption
implements TransitionMap.PageInitializer {
    private static final String EXISTING_PXRPT = "existingPxrpt";
    public static final String PXRPTUSER_EXISTS = "pxrptuser_exists";
    private static final String IS_UPGRADE = "isupgrade";

    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws Exception {
        String connectionSting;
        boolean pxrptuserExists;
        boolean isSqlServer = !PageInitializerHelper.isOracle(jobProps, data);
        data.getPageData(page).setValue("isSqlServer", Boolean.toString(isSqlServer));
        boolean isUpgrade = PageInitializerHelper.isUpgrade(jobProps, data);
        if (data.getPageData(page).getText(IS_UPGRADE) != null) {
            data.getPageData(page).setValue(IS_UPGRADE, Boolean.toString(isUpgrade));
        }
        boolean isInstall = PageInitializerHelper.isInstall(jobProps, data);
        DatapumpJob.toLoad(isInstall);
        boolean value = jobProps.getJobProperty(InstallSuiteOptionKeys.PM_PRODUCT_KEY) == SchemaType.PM;
        boolean versionAlreadyHasPxrptUser = PageInitializerHelper.hasPxrptuser(jobProps, data);
        boolean bl = pxrptuserExists = value && versionAlreadyHasPxrptUser;
        if (data.getPageData(page).getText(PXRPTUSER_EXISTS) != null) {
            data.getPageData(page).setValue(PXRPTUSER_EXISTS, Boolean.toString(pxrptuserExists));
        }
        ArrayList<String> usersList = new ArrayList<String>();
        if (!isSqlServer && !isUpgrade) {
            return null;
        }
        if (isSqlServer) {
            connectionSting = jobProps.getConnection(ConnectionClass.SYSADMIN);
            if (isUpgrade && pxrptuserExists) {
                usersList.addAll(this.getSSPxUserList(connectionSting));
            } else {
                usersList.addAll(this.getAllbutPubPrivDboUsers(connectionSting));
            }
        } else if (pxrptuserExists) {
            connectionSting = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
            usersList.addAll(this.getORPxUserList(connectionSting));
        } else {
            return null;
        }
        SelectTypeDef typeDefPxRpt = (SelectTypeDef)data.getPageData(page).getDef().getTypeDef(EXISTING_PXRPT);
        typeDefPxRpt.reset();
        for (String username : usersList) {
            typeDefPxRpt.addValue(new EnumDataEntry(username, username, username, ""));
        }
        if (typeDefPxRpt.getValues().size() > 0) {
            data.getPageData(page).setValue(EXISTING_PXRPT, typeDefPxRpt.getValues().get(0).getId());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getSSPxUserList(String connectionSting) throws SQLException {
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(connectionSting);
            SqlServerLogic sl = new SqlServerLogic();
            List<String> rawList = sl.getSortedPossiblePxrptusers(connection);
            List<String> list = this.processRawList(rawList);
            return list;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getORPxUserList(String connectionSting) throws SQLException {
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(connectionSting);
            OracleLogic ol = new OracleLogic();
            List<String> rawList = ol.getSortedPossiblePxrptusers(connection);
            List<String> list = this.processRawList(rawList);
            return list;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getAllbutPubPrivDboUsers(String connectionSting) throws SQLException {
        DatabaseConnection connection = null;
        try {
            connection = new DatabaseConnection(connectionSting);
            List<String> rawList = SqlServerLogic.getAllbutPubPrivDboUsers(connection);
            List<String> list = this.processRawList(rawList);
            return list;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, e.getLocalizedMessage());
                }
            }
        }
    }

    private List<String> processRawList(List<String> rawList) {
        return rawList;
    }
}

