/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.UnknownProductSuiteException;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.util.TablespaceUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SetDefaultNewExpTablespaceNames
implements TransitionMap.PageInitializer {
    private final ConnectionClass m_connectionType;
    private final Map<String, String> m_fieldTablespaceMap = new HashMap<String, String>();

    public SetDefaultNewExpTablespaceNames(ConnectionClass connectionType, Map<String, String> fieldTablespaceMap) {
        this.m_connectionType = connectionType;
        this.m_fieldTablespaceMap.putAll(fieldTablespaceMap);
    }

    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws InteractorDataError, DBMTException, UnknownProductSuiteException {
        if (jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_SUITE_KEY) != ProductSuiteType.EXP) {
            return null;
        }
        HashSet<String> availableTablespaces = new HashSet<String>();
        try {
            availableTablespaces.addAll(TablespaceUtil.getAvailableTablespaces(jobProps.getConnection(this.m_connectionType)).keySet());
        }
        catch (ConnectionNotFoundException e) {
            return e.getLocalizedMessage();
        }
        for (Map.Entry<String, String> entry : this.m_fieldTablespaceMap.entrySet()) {
            String tablespaceName = SetDefaultNewExpTablespaceNames.findTablespaceName(availableTablespaces, entry.getValue());
            data.getPageData(page).setValue(entry.getKey(), tablespaceName);
        }
        return null;
    }

    private static String findTablespaceName(Set<String> availableTablespaces, String defaultTablespaceName) {
        if (!availableTablespaces.contains(defaultTablespaceName)) {
            return defaultTablespaceName;
        }
        int numericSuffix = 1;
        String canidateBaseName = defaultTablespaceName;
        int canidateBaseNameEnd = SetDefaultNewExpTablespaceNames.getCanidateBaseNameEnd(defaultTablespaceName);
        if (canidateBaseNameEnd < defaultTablespaceName.length()) {
            canidateBaseName = defaultTablespaceName.substring(0, canidateBaseNameEnd);
            numericSuffix = Integer.parseInt(defaultTablespaceName.substring(canidateBaseNameEnd));
        }
        String canidateName = canidateBaseName + numericSuffix;
        while (availableTablespaces.contains(canidateName)) {
            canidateName = canidateBaseName + ++numericSuffix;
        }
        return canidateName;
    }

    private static int getCanidateBaseNameEnd(String defaultTablespaceName) {
        int len = defaultTablespaceName.length();
        for (int i = 0; i < len; ++i) {
            int next = len - (i + 1);
            if (Character.isDigit(defaultTablespaceName.charAt(next))) continue;
            return next + 1;
        }
        return 0;
    }
}

