/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionFailed;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.ServerInfo;
import com.primavera.database.tools.dbmt.actions.BaseWizardProgressor;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.NavigationalWizardAction;
import com.primavera.database.tools.dbmt.actions.SchemaValidationPages;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Properties;

public class SchemaValidationWizardAction
extends NavigationalWizardAction<ApplicationContextLogic>
implements SchemaValidationPages {
    private ServerInfo m_serverInfo;

    public SchemaValidationWizardAction(ApplicationContextLogic contextLogic) {
        super(contextLogic);
        this.addPage(new ProductChooseApplicationPage(this, "application"));
        this.addPage(new CreateOracleServerConnectionPageForSource(this, "connect_or"));
    }

    @Override
    public void performWizardAction(WizardInteractorData data) throws ActionFailed, InteractorDataError {
    }

    private static class ProductChooseApplicationPage
    extends BaseWizardProgressor<SchemaValidationWizardAction> {
        public ProductChooseApplicationPage(SchemaValidationWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            return null;
        }
    }

    private static class CreateOracleServerConnectionPageForSource
    extends CreateServerConnectionPage {
        public CreateOracleServerConnectionPageForSource(SchemaValidationWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            return super.proceed(runner, data, jobProps);
        }

        protected Properties getScriptProperties(ServerType type, WizardInteractorData data) throws InteractorDataError {
            Properties props = new Properties();
            props.put("pm.ss.privileged_user", "privuser");
            return props;
        }

        protected String getConnectionString(SchemaValidationWizardAction action, WizardInteractorData data) throws InteractorDataError, SQLException {
            String serverType = data.getValue("select_server_type_source", "servertype");
            if (serverType.toUpperCase().equals("SS")) {
                return action.m_serverInfo.createConnectString(action.m_serverInfo.getPassword(), data.getValue("select_server_type_source", "database"));
            }
            OracleServerInfo serverInfo = new OracleServerInfo("temp", action.m_serverInfo.getHost(), data.getValue("select_server_type_source", "database"));
            return serverInfo.createConnectString(data.getValue("connect_or", "admuser"), data.getValue("select_server_type_source", "database"));
        }

        @Override
        protected ServerInfo createServer(WizardInteractorData data) throws InteractorDataError, NumberFormatException, SQLException {
            OracleServerInfo oracleServerInfo = new OracleServerInfo("temp", data.getValue(this.getPage(), "host"), data.getValue(this.getPage(), "instance"));
            oracleServerInfo.setPort(Integer.parseInt(data.getValue(this.getPage(), "port")));
            oracleServerInfo.setUsername(data.getValue(this.getPage(), "username"));
            oracleServerInfo.setPassword(data.getValue(this.getPage(), "password"));
            oracleServerInfo.setDatabase(data.getValue(this.getPage(), "instance"));
            oracleServerInfo.setService("SERVICE".equalsIgnoreCase(data.getValue(this.getPage(), "ctype")));
            oracleServerInfo.connect(data.getValue(this.getPage(), "password"), data.getValue(this.getPage(), "instance"));
            ((SchemaValidationWizardAction)this.getAction()).m_serverInfo = oracleServerInfo;
            return oracleServerInfo;
        }

        @Override
        protected void doPostConnectionLogic() throws Exception {
        }
    }

    private static abstract class CreateServerConnectionPage
    extends BaseWizardProgressor<SchemaValidationWizardAction> {
        public CreateServerConnectionPage(SchemaValidationWizardAction action, String page) {
            super(action, page);
        }

        @Override
        public void prepare(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) throws InteractorDataError {
            String currentHostValue = data.getValue(this.getPage(), "host");
            if (currentHostValue != null) {
                return;
            }
            try {
                InetAddress localMachine = InetAddress.getLocalHost();
                data.getPageData(this.getPage()).setValue("host", localMachine.getHostName());
            }
            catch (UnknownHostException e) {
                DBMTLogger.warn(Channel.DEV, "Unable to get hostname?  " + e.getClass().getSimpleName() + ": " + e.getMessage());
            }
        }

        @Override
        public String proceed(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
            try {
                this.createServer(data);
                this.doPostConnectionLogic();
            }
            catch (Throwable e) {
                return e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            }
            return null;
        }

        protected abstract void doPostConnectionLogic() throws Exception;

        protected abstract ServerInfo createServer(WizardInteractorData var1) throws InteractorDataError, NumberFormatException, SQLException;

        @Override
        public final void undo(WizardRunner runner, WizardInteractorData data, JobProperties jobProps) {
        }
    }
}

