/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.PhoenixException;
import com.primavera.common.util.EntryPoint;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class ReEncryptUserPasswords {
    private static final String DIGEST_PASSWORD_PREFIX = "SHA-256:";
    private static final String UPDATE_USERS_STMT = "UPDATE users SET passwd = ? where user_id = ?";
    private static final String SELECT_USERS_QUERY = "SELECT user_id, report_user_flag, passwd FROM users";
    private final DatabaseConnection m_conn;

    public ReEncryptUserPasswords(DatabaseConnection conn) {
        this.m_conn = conn;
    }

    public void encryptUserPasswords() throws Exception {
        DBMTLogger.info(Channel.DEV, "Calling " + this.getClass().getSimpleName() + "." + "encryptUserPasswords");
        Statement stmt = null;
        ResultSet results = null;
        try {
            stmt = this.m_conn.getConnection().createStatement();
            results = stmt.executeQuery(SELECT_USERS_QUERY);
            HashMap<Integer, String> reportingUsers = new HashMap<Integer, String>();
            HashMap<Integer, String> nonReportingUsers = new HashMap<Integer, String>();
            ReEncryptUserPasswords.populateUserSets(results, reportingUsers, nonReportingUsers);
            this.updateUserPasswords(reportingUsers, new ConvertReportingUserPassword());
            this.updateUserPasswords(nonReportingUsers, new ConvertNonReportingUserPassword());
        }
        catch (RuntimeException e) {
            DBMTLogger.error(Channel.DEV, this.getClass().getSimpleName() + ".updateUserPasswords: threw exception", e);
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.error.reencrypt.pass"));
            throw e;
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
            try {
                if (results != null) {
                    results.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    private void updateUserPasswords(Map<Integer, String> userMap, ConvertPassword paswordConverter) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = this.m_conn.getConnection().prepareStatement(UPDATE_USERS_STMT);
            for (Map.Entry<Integer, String> e : userMap.entrySet()) {
                int userId = e.getKey();
                String password = e.getValue();
                if (password == null) {
                    password = "";
                }
                try {
                    String convertedPassword = paswordConverter.convert(password);
                    stmt.setString(1, convertedPassword);
                    stmt.setInt(2, userId);
                    stmt.execute();
                }
                catch (PhoenixException phex) {
                    phex.printStackTrace();
                }
            }
        }
        catch (RuntimeException e) {
            DBMTLogger.error(Channel.DEV, this.getClass().getSimpleName() + ".updateUserPasswords: threw exception", e);
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.error.reencrypt.pass"));
            throw e;
        }
        finally {
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static void populateUserSets(ResultSet results, Map<Integer, String> reportingUsers, Map<Integer, String> nonReportingUsers) throws SQLException {
        DBMTLogger.info(Channel.DEV, "populateUserSets: results = " + results + ", reporting users = " + reportingUsers + ", nonreporting users = " + nonReportingUsers);
        while (results.next()) {
            String reportingUser = results.getString("report_user_flag");
            int userId = results.getInt("user_id");
            String encryptedPass = results.getString("passwd");
            DBMTLogger.info(Channel.DEV, "UserID = " + userId + ", Reporting User = " + reportingUser + ", Encrypted Password = " + encryptedPass);
            if (reportingUser == null) {
                reportingUser = "N";
            }
            if (encryptedPass == null) {
                encryptedPass = "";
            }
            if (encryptedPass.startsWith(DIGEST_PASSWORD_PREFIX)) continue;
            try {
                String decryptedPass = EntryPoint.d((String)encryptedPass);
                if (reportingUser != null && "Y".equals(reportingUser)) {
                    reportingUsers.put(userId, decryptedPass);
                    continue;
                }
                nonReportingUsers.put(userId, decryptedPass);
            }
            catch (PhoenixException e) {
                DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.action.error.cannot.reencrypt.pass", new String[]{Integer.toString(userId)}));
            }
        }
    }

    private final class ConvertReportingUserPassword
    implements ConvertPassword {
        private ConvertReportingUserPassword() {
        }

        @Override
        public String convert(String origPassword) throws PhoenixException {
            return EntryPoint.e((String)origPassword);
        }
    }

    private final class ConvertNonReportingUserPassword
    implements ConvertPassword {
        private ConvertNonReportingUserPassword() {
        }

        @Override
        public String convert(String origPassword) throws PhoenixException {
            return EntryPoint.e((String)origPassword);
        }
    }

    private static interface ConvertPassword {
        public String convert(String var1) throws PhoenixException;
    }
}

