/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ServerType;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.InvalidVersionStringException;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SetActionTypeTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.util.SchemaVersionsCompare;

public class PageInitializerHelper {
    private static final String FIRST_SCHEMA_VERSION_WITH_PXRPT_USER = "0810.0001.0001.0010";

    public static boolean isOracle(JobProperties jobProps, WizardInteractorData data) {
        boolean isOracle = false;
        try {
            if (jobProps.getJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY) == ServerType.ORACLE || jobProps.getJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY) == ServerType.ORACLEATP) {
                isOracle = true;
            }
        }
        catch (JobPropertyNotFound e1) {
            try {
                String dbType = data.getValue("operation_pm", "servertype");
                isOracle = dbType.toUpperCase().equals("OR");
            }
            catch (InteractorDataError e) {
                DBMTLogger.warn(Channel.DEV, e.getLocalizedMessage());
            }
        }
        return isOracle;
    }

    public static boolean isUpgrade(JobProperties jobProps, WizardInteractorData data) {
        boolean isUpgrade = false;
        try {
            isUpgrade = jobProps.getJobProperty(SetActionTypeTransOp.ACTION_TYPE_KEY) == ActionType.UPGRADE;
        }
        catch (JobPropertyNotFound e1) {
            try {
                String dbType = data.getValue("operation_pm", "operation");
                isUpgrade = dbType.toLowerCase().equals("upgrade");
            }
            catch (InteractorDataError e) {
                DBMTLogger.warn(Channel.DEV, e.getLocalizedMessage());
            }
        }
        return isUpgrade;
    }

    public static boolean hasPxrptuser(JobProperties jobProps, WizardInteractorData data) {
        boolean hasPxrptuser = false;
        try {
            hasPxrptuser = SchemaVersionsCompare.versionGreaterThanOrEqualTo(jobProps.getJobProperty(InstallSuiteOptionKeys.PRODUCT_INSTALLED_VERSION_KEY).toString(), FIRST_SCHEMA_VERSION_WITH_PXRPT_USER);
        }
        catch (JobPropertyNotFound e1) {
            return false;
        }
        catch (InvalidVersionStringException e) {
            DBMTLogger.warn(Channel.DEV, e.getLocalizedMessage());
        }
        return hasPxrptuser;
    }

    public static boolean isInstall(JobProperties jobProps, WizardInteractorData data) {
        boolean isInstall = false;
        try {
            isInstall = jobProps.getJobProperty(SetActionTypeTransOp.ACTION_TYPE_KEY) == ActionType.INSTALL;
        }
        catch (JobPropertyNotFound e1) {
            try {
                String dbType = data.getValue("operation_pm", "operation");
                isInstall = dbType.toLowerCase().equals("install");
            }
            catch (InteractorDataError e) {
                DBMTLogger.warn(Channel.DEV, e.getLocalizedMessage());
            }
        }
        return isInstall;
    }
}

