/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import java.util.HashSet;

public class InitializeSSUsersPage
implements TransitionMap.PageInitializer {
    private final ConnectionClass m_connectStringName;
    private final String[][] m_userNameAndPassFields;

    public InitializeSSUsersPage(ConnectionClass connectStringName, String[][] userNameAndPassFields) {
        this.m_connectStringName = connectStringName;
        this.m_userNameAndPassFields = userNameAndPassFields;
    }

    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String page) throws Exception {
        HashSet<String> existingSSUsers = new HashSet<String>();
        String connectionString = null;
        try {
            connectionString = jobProps.getConnection(this.m_connectStringName);
        }
        catch (ConnectionNotFoundException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        existingSSUsers.addAll(SqlServerLogic.getExistingUsers(connectionString));
        for (String[] fieldIds : this.m_userNameAndPassFields) {
            if (fieldIds == null || fieldIds.length == 0) continue;
            String value = SqlServerLogic.getDefaultSSUserName(existingSSUsers, data.getValue(page, fieldIds[0]));
            data.getPageData(page).setValue(fieldIds[0], value);
        }
        return null;
    }
}

