/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.FieldTable;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class GenericScriptATPParamaterSetter
implements TransitionMap.TransitionOperation {
    private final FieldTable m_fields;

    public GenericScriptATPParamaterSetter(FieldTable fields) {
        this.m_fields = fields;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException {
        for (String scriptParam : this.m_fields.getParams()) {
            try {
                if (scriptParam.equals("temporary_tablespace")) {
                    jobProps.getScriptProperties().put(scriptParam, "TEMP");
                    continue;
                }
                jobProps.getScriptProperties().put(scriptParam, "DATA");
            }
            catch (Exception e) {
                return e.getClass().getSimpleName() + ": " + e.getMessage() + " (" + e.getLocalizedMessage() + ")";
            }
        }
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        for (String scriptParam : this.m_fields.getParams()) {
            properties.getScriptProperties().remove(scriptParam);
        }
    }
}

