/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.ServerType;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.JobFailedEvent;
import com.primavera.database.common.job.JobListenerAdaptor;
import com.primavera.database.common.job.JobWatcher;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.AbstractJobAdder;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InstallSuiteOptionKeys;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;
import java.util.ArrayList;
import java.util.List;

public class CreateSSDatabaseTransOp
implements TransitionMap.TransitionOperation {
    private final ApplicationContextLogic m_contextLogic;

    public CreateSSDatabaseTransOp(ApplicationContextLogic contextLogic) {
        this.m_contextLogic = contextLogic;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        Object job;
        List<ParameterizedJobFactory<?>> jobFactories;
        if (jobProps.getJobProperty(InstallSuiteOptionKeys.SERVER_TYPE_KEY) != ServerType.SQLSERVER) {
            return null;
        }
        ActionClass createActionClass = AbstractJobAdder.getActionClass(ActionType.DBCREATE, jobProps);
        ActionClass usersActionClass = AbstractJobAdder.getActionClass(ActionType.DBUSERS, jobProps);
        ArrayList<Job> jobs = new ArrayList<Job>();
        for (SchemaInfo schemaInfo : AbstractJobAdder.getSchemaInfo(jobProps)) {
            jobFactories = this.m_contextLogic.getApp().getSchemaSteps(schemaInfo, createActionClass);
            for (ParameterizedJobFactory<?> factory : jobFactories) {
                job = factory.createJob(jobProps);
                jobs.add((Job)job);
            }
        }
        for (SchemaInfo schemaInfo : AbstractJobAdder.getSchemaInfo(jobProps)) {
            jobFactories = this.m_contextLogic.getApp().getSchemaSteps(schemaInfo, usersActionClass);
            for (ParameterizedJobFactory<?> factory : jobFactories) {
                job = factory.createJob(jobProps);
                jobs.add((Job)job);
            }
        }
        ThrowingJobListener exceptionPropogator = new ThrowingJobListener();
        runner.commit(exceptionPropogator, jobs, new JobWatcher());
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
    }

    private final class ThrowingJobListener
    extends JobListenerAdaptor {
        private ThrowingJobListener() {
        }

        @Override
        public void jobFailed(JobFailedEvent evt) {
            throw new RuntimeException(evt.toString());
        }
    }
}

