/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.SchemaType;
import com.primavera.database.common.connection.DatabaseConnection;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.JobPropertyNotFound;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.mssql.SqlServerLogic;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;

public abstract class ConfigSSDBInitialize
implements TransitionMap.PageInitializer {
    private final ConnectionClass m_connectionName;

    public ConfigSSDBInitialize(ConnectionClass connectionName) {
        this.m_connectionName = connectionName;
    }

    protected abstract SchemaType getSchemaType(JobProperties var1) throws JobPropertyNotFound;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String initializePage(JobProperties jobProps, WizardInteractorData data, String m_config_ss_db_page) throws InteractorDataError, JobPropertyNotFound {
        String defaultDataFile = "";
        String defaultLogFile = "";
        SchemaType type = this.getSchemaType(jobProps);
        String currentDBNameValue = data.getValue(m_config_ss_db_page, "dbname");
        String defaultDBNameValue = data.getPageData(m_config_ss_db_page).getDef().get("dbname").getDefaultValue();
        String defaultDFDir = "";
        DatabaseConnection connection = null;
        if (currentDBNameValue == null) {
            currentDBNameValue = "";
        }
        if (defaultDBNameValue == null) {
            defaultDBNameValue = "";
        }
        try {
            String defaultDbName;
            connection = new DatabaseConnection(jobProps.getConnection(this.m_connectionName));
            if ((currentDBNameValue == null && defaultDBNameValue == null || currentDBNameValue != null && defaultDBNameValue != null && currentDBNameValue.equals(defaultDBNameValue)) && (defaultDbName = ConfigSSDBInitialize.getDefaultDbName(type, data, SqlServerLogic.getDatabaseNames(connection))) != null) {
                data.getPageData(m_config_ss_db_page).setValue("dbname", defaultDbName);
            }
            defaultDFDir = SqlServerLogic.getMasterFileDirectory(connection);
        }
        catch (SQLException e) {
            String string = e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            return string;
        }
        catch (ConnectionNotFoundException e) {
            String string = e.getClass().getSimpleName() + ": " + e.getLocalizedMessage();
            return string;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    DBMTLogger.warn(Channel.USER, "dbmt.warn.connection.not.closed");
                }
            }
        }
        defaultDataFile = defaultDFDir + "\\" + data.getPageData(m_config_ss_db_page).getValue("dbname") + "_DAT.MDF";
        defaultLogFile = defaultDFDir + "\\" + data.getPageData(m_config_ss_db_page).getValue("dbname") + "_LOG.LDF";
        data.getPageData(m_config_ss_db_page).setValue("datafile", defaultDataFile);
        data.getPageData(m_config_ss_db_page).setValue("logfile", defaultLogFile);
        return null;
    }

    public static String getDefaultDbName(SchemaType type, WizardInteractorData data, Set<String> existingDatabases) throws InteractorDataError {
        String baseDefaultDBName = "";
        if (type == SchemaType.MM) {
            baseDefaultDBName = "MMDB";
        } else if (type == SchemaType.PM || type == SchemaType.PPM) {
            baseDefaultDBName = "PMDB";
        } else if (type == SchemaType.JR) {
            baseDefaultDBName = "REPO";
        } else if (type == SchemaType.EXP) {
            baseDefaultDBName = "CMPROJ";
        } else if (type == SchemaType.EXPADM) {
            baseDefaultDBName = "EXPADMIN";
        }
        HashSet<String> dbNameSet = new HashSet<String>();
        for (String dbInfo : existingDatabases) {
            dbNameSet.add(dbInfo.toUpperCase());
        }
        if (!dbNameSet.contains(baseDefaultDBName)) {
            return baseDefaultDBName;
        }
        int i = 1;
        String dbNameCanidate;
        while (dbNameSet.contains(dbNameCanidate = baseDefaultDBName + i)) {
            ++i;
        }
        return dbNameCanidate;
    }
}

