/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.FieldTable;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ProcessedParam;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class ConditionalGenericScriptParameterSetter
implements TransitionMap.TransitionOperation {
    private FieldTable m_fields;
    private final FieldTable m_fieldsTrue;
    private final FieldTable m_fieldsFalse;
    private final String m_checkCondition;

    public ConditionalGenericScriptParameterSetter(String checkCondition, FieldTable fieldsTrue, FieldTable fieldsFalse) {
        this.m_fieldsTrue = fieldsTrue;
        this.m_fieldsFalse = fieldsFalse;
        this.m_checkCondition = checkCondition;
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException {
        this.m_fields = data.getValue(page, this.m_checkCondition).equalsIgnoreCase("true") ? this.m_fieldsTrue : this.m_fieldsFalse;
        for (String scriptParam : this.m_fields.getParams()) {
            if (scriptParam.equals("pm.px_tablespace") && page.equals("configure_px_users") && "true".equalsIgnoreCase(data.getValue(page, "useexistingpxrptuser"))) continue;
            ProcessedParam wizardParam = this.m_fields.getParam(scriptParam);
            String wizardValue = data.getValue(page, wizardParam.getFieldName());
            if (wizardValue == null) {
                wizardValue = "";
            }
            try {
                jobProps.getScriptProperties().put(scriptParam, wizardParam.getProc().process(wizardValue));
            }
            catch (Exception e) {
                return e.getClass().getSimpleName() + ": " + e.getMessage() + " (" + e.getLocalizedMessage() + ")";
            }
        }
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        if (this.m_fields != null) {
            for (String scriptParam : this.m_fields.getParams()) {
                properties.getScriptProperties().remove(scriptParam);
            }
        }
    }
}

