/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.connection.ConnectStringParse;
import com.primavera.database.tools.ConnectionClass;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.SetConnectStringTransOp;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.dbservers.oracle.OracleServerInfo;
import java.util.Properties;

public class AddPubUserTransOp
extends SetConnectStringTransOp {
    public AddPubUserTransOp(boolean verify, Properties fieldOverrides) {
        super(ConnectionClass.PUBUSER, verify, fieldOverrides);
    }

    public AddPubUserTransOp(boolean verify) {
        this(verify, new Properties());
    }

    @Override
    protected String createConnectString(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, Exception {
        String pubUserName = data.getPageData(page).getValue("pubuser");
        String pubPassword = data.getPageData(page).getValue("pubpass");
        String adminConnectionString = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        ConnectStringParse parsedAdminConnection = new ConnectStringParse(adminConnectionString);
        String host = parsedAdminConnection.getServer();
        String port = parsedAdminConnection.getPort();
        String instance = parsedAdminConnection.getDatabase();
        OracleServerInfo info = new OracleServerInfo("", "", "");
        info.setHost(host);
        info.setPort(Integer.parseInt(port));
        info.setDatabase(instance);
        info.setUsername(pubUserName);
        info.setService(parsedAdminConnection.isOracleService());
        return info.createConnectString(pubPassword);
    }

    @Override
    protected String createConnectStringATP(WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, Exception {
        String pubUserName = data.getPageData(page).getValue("pubuser");
        String pubPassword = data.getPageData(page).getValue("pubpass");
        String adminConnectionString = jobProps.getConnection(ConnectionClass.ADMINISTRATIVE);
        ConnectStringParse parsedAdminConnection = new ConnectStringParse(adminConnectionString);
        String dbService = parsedAdminConnection.getDatabase();
        OracleServerInfo info = new OracleServerInfo("", "", "");
        info.setDatabase(dbService);
        info.setUsername(pubUserName);
        String connectString = parsedAdminConnection.getConnectstring();
        return info.createATPConnectString(pubPassword, connectString);
    }
}

