/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.TransitionMap;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import com.primavera.database.tools.dbmt.actions.WizardRunner;

public class AddFieldValueToPropertiesTransOp
implements TransitionMap.TransitionOperation {
    public final String wizardField;
    public final String propertyName;

    public AddFieldValueToPropertiesTransOp(String wname, String pname) {
        this.wizardField = wname;
        this.propertyName = pname;
    }

    public AddFieldValueToPropertiesTransOp(String name) {
        this(name, name);
    }

    @Override
    public String process(WizardRunner runner, WizardInteractorData data, String page, JobProperties jobProps) throws InteractorDataError, ValueNotFound, ConnectionNotFoundException, DBMTException {
        String value = data.getValue(page, this.wizardField);
        jobProps.setJobProperty(this.propertyName, value);
        return null;
    }

    @Override
    public void unProcess(WizardRunner runner, JobProperties properties) throws InteractorDataError {
        properties.getJobPropertyEntries().remove(this.propertyName);
    }
}

