/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt.actions;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaType;
import com.primavera.database.common.job.Job;
import com.primavera.database.common.job.ValueNotFound;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.ActionType;
import com.primavera.database.tools.dbmt.ApplicationContextLogic;
import com.primavera.database.tools.dbmt.DBMTException;
import com.primavera.database.tools.dbmt.ProductInfo;
import com.primavera.database.tools.dbmt.actions.AbstractJobAdder;
import com.primavera.database.tools.dbmt.actions.ConnectionNotFoundException;
import com.primavera.database.tools.dbmt.actions.InteractorDataError;
import com.primavera.database.tools.dbmt.actions.JobProperties;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import com.primavera.database.tools.dbmt.actions.WizardInteractorData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class AddCROnlyInstallJobs
extends AbstractJobAdder {
    private final ApplicationContextLogic m_context;
    private final ActionType m_type;

    public AddCROnlyInstallJobs(String pageId, ActionType type, ApplicationContextLogic contextLogic) {
        super(pageId);
        this.m_context = contextLogic;
        this.m_type = type;
    }

    @Override
    protected void getJobsToAdd(WizardInteractorData data, JobProperties jobProps, List<Job> jobs) throws ValueNotFound, ConnectionNotFoundException, InteractorDataError, DBMTException {
        List<SchemaInfo> infos = this.getCRSchemaInfo(data, jobProps);
        ActionClass createActionClass = AddCROnlyInstallJobs.getActionClass(this.m_type, jobProps);
        ArrayList jobFactories = new ArrayList();
        for (SchemaInfo schemaInfo : infos) {
            jobFactories.addAll(this.m_context.getApp().getSchemaSteps(schemaInfo, createActionClass));
        }
        for (ParameterizedJobFactory parameterizedJobFactory : jobFactories) {
            jobs.add((Job)parameterizedJobFactory.createJob(jobProps));
        }
    }

    private List<SchemaInfo> getCRSchemaInfo(WizardInteractorData data, JobProperties jobProps) {
        ArrayList<SchemaInfo> schemas = new ArrayList<SchemaInfo>();
        ProductInfo productInfo = this.getProductInfo();
        HashMap<SchemaType, SchemaInfo> schemaMap = new HashMap<SchemaType, SchemaInfo>();
        for (SchemaInfo info : productInfo.getAllSchemas()) {
            schemaMap.put(info.getSchemaType(), info);
        }
        schemas.add((SchemaInfo)schemaMap.get((Object)SchemaType.JR));
        return schemas;
    }

    protected ProductInfo getProductInfo() {
        List<ProductInfo> productInfoList = this.m_context.getApp().getSuiteInfo(ProductSuiteType.PM);
        ProductInfo productInfo = null;
        for (ProductInfo info : productInfoList) {
            if (productInfo != null && productInfo.getVersion().compareTo(info.getVersion()) >= 0) continue;
            productInfo = info;
        }
        return productInfo;
    }
}

