/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.ProductVersion;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.SchemaInfoImpl;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.BaseProductInfo;
import com.primavera.database.tools.dbmt.ProductId;
import com.primavera.database.tools.dbmt.ProductInfo;
import com.primavera.database.tools.dbmt.xml.util.NodeHandler;
import com.primavera.database.tools.dbmt.xml.util.NodeLink;
import com.primavera.database.tools.dbmt.xml.util.SimpleHandler;
import com.primavera.database.tools.dbmt.xml.util.suite.nodes.SuiteNode;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProductInfoImpl
extends BaseProductInfo {
    private final ProductId m_productId;
    private final Set<SchemaInfo> m_reqSchemas = new HashSet<SchemaInfo>();
    private final Set<SchemaInfo> m_optSchemas = new HashSet<SchemaInfo>();

    public ProductInfoImpl(ProductId productId) {
        this.m_productId = productId;
    }

    public void addSchema(SchemaInfo schema, boolean required) {
        if (required) {
            this.m_reqSchemas.add(schema);
        } else {
            this.m_optSchemas.add(schema);
        }
    }

    @Override
    public Set<SchemaInfo> getOptionalSchemas() {
        return this.m_optSchemas;
    }

    @Override
    public Set<SchemaInfo> getRequiredSchemas() {
        return this.m_reqSchemas;
    }

    @Override
    public ProductSuiteType getSuite() {
        return this.m_productId.getType();
    }

    @Override
    public ProductVersion getVersion() {
        return this.m_productId.getVersion();
    }

    public String toString() {
        return "[ProductInfo: " + this.m_productId + "]";
    }

    public static String getSuiteFileLocationFromJarFile(File file) {
        SchemaInfoImpl info = SchemaInfoImpl.createFromFileName(file.getName());
        String maj = ProductVersion.format(info.getMajVersion());
        String min = ProductVersion.format(info.getMinVersion());
        String rel = ProductVersion.format(info.getRelVersion());
        String path = "install/" + (Object)((Object)info.getSchemaType()) + "_" + maj + "_" + min + "_" + rel + "/" + "Suite.xml";
        return path;
    }

    public static ProductInfo extractFromJarFile(File file) {
        String resourceLoc = ProductInfoImpl.getSuiteFileLocationFromJarFile(file);
        try {
            JarFile jarFile = new JarFile(file);
            ZipEntry zipEntry = jarFile.getEntry(resourceLoc);
            if (zipEntry == null) {
                return null;
            }
            InputStream instream = jarFile.getInputStream(zipEntry);
            if (instream != null) {
                try {
                    return ProductInfoImpl.parseSchemaWorkflowFile(instream);
                }
                catch (Exception e) {
                    DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.schemaloader.unabletoloadsuitefromjar", new String[]{resourceLoc, file.getAbsolutePath(), e.toString()}));
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static ProductInfo parseSchemaWorkflowFile(InputStream in) throws ParserConfigurationException, SAXException, IOException {
        ProductSuiteRootHandler start = new ProductSuiteRootHandler();
        SimpleHandler handler = new SimpleHandler(start);
        SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
        parser.parse(in, (DefaultHandler)handler);
        return start.getInfo();
    }

    private static class ProductSuiteRootHandler
    implements NodeLink {
        private SuiteNode m_rootNode;

        private ProductSuiteRootHandler() {
        }

        @Override
        public NodeHandler nextNode(String elemName, Attributes attr) {
            if ("suite".equals(elemName)) {
                this.m_rootNode = new SuiteNode(attr);
                return this.m_rootNode;
            }
            return null;
        }

        @Override
        public String path() {
            return "";
        }

        public ProductInfo getInfo() {
            if (this.m_rootNode == null) {
                return null;
            }
            return this.m_rootNode.getInfo();
        }
    }
}

