/*
 * Decompiled with CFR 0.152.
 */
package com.primavera.database.tools.dbmt;

import com.primavera.database.common.DynamicClassLoader;
import com.primavera.database.common.ProductSuiteType;
import com.primavera.database.common.SchemaInfo;
import com.primavera.database.common.locale.StringLocalizer;
import com.primavera.database.common.logging.Channel;
import com.primavera.database.common.logging.DBMTLogger;
import com.primavera.database.tools.dbmt.ActionClass;
import com.primavera.database.tools.dbmt.ActionLoader;
import com.primavera.database.tools.dbmt.ActionLogicManagerImpl;
import com.primavera.database.tools.dbmt.Application;
import com.primavera.database.tools.dbmt.ApplicationEventSource;
import com.primavera.database.tools.dbmt.ApplicationListener;
import com.primavera.database.tools.dbmt.DatabaseInfo;
import com.primavera.database.tools.dbmt.ExtentionLoadedListener;
import com.primavera.database.tools.dbmt.ExtentionManager;
import com.primavera.database.tools.dbmt.ProductInfo;
import com.primavera.database.tools.dbmt.ProductInfoImpl;
import com.primavera.database.tools.dbmt.SchemaMap;
import com.primavera.database.tools.dbmt.ServerInfo;
import com.primavera.database.tools.dbmt.SuiteMap;
import com.primavera.database.tools.dbmt.actions.ParameterizedJobFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;

public class ApplicationImpl
implements ApplicationEventSource,
Application,
ExtentionLoadedListener {
    private final Collection<ApplicationListener> m_listeners = new ArrayList<ApplicationListener>();
    private final Collection<ServerInfo> m_serverCollection = new HashSet<ServerInfo>();
    private final Map<ServerInfo, Collection<DatabaseInfo>> m_databaseMap = new HashMap<ServerInfo, Collection<DatabaseInfo>>();
    private final SchemaMap m_schemaMap = new SchemaMap();
    private final SuiteMap m_suiteMap = new SuiteMap();

    private ApplicationImpl() {
        ExtentionManager.inst().addListener(this);
    }

    public static ApplicationImpl createApplication() {
        return new ApplicationImpl();
    }

    @Override
    public synchronized void addApplicationListener(ApplicationListener l) {
        if (this.m_listeners.contains(l)) {
            return;
        }
        this.m_listeners.add(l);
    }

    @Override
    public synchronized void removeApplicationListener(ApplicationListener l) {
        this.m_listeners.remove(l);
    }

    @Override
    public void addServers(Collection<ServerInfo> servers) {
        this.m_serverCollection.addAll(servers);
        for (ServerInfo server : servers) {
            this.m_databaseMap.put(server, new HashSet());
        }
        for (ApplicationListener l : this.m_listeners) {
            l.serversAdded(servers);
        }
    }

    @Override
    public void serverStateChanged(ServerInfo server) {
        HashSet<ServerInfo> servers = new HashSet<ServerInfo>();
        servers.add(server);
        for (ApplicationListener l : this.m_listeners) {
            l.serversAltered(servers);
        }
    }

    @Override
    public void deleteServers(Collection<ServerInfo> servers) {
        this.m_serverCollection.removeAll(servers);
        for (ServerInfo server : servers) {
            this.m_databaseMap.remove(server);
        }
        for (ApplicationListener l : this.m_listeners) {
            l.serversDeleted(servers);
        }
    }

    @Override
    public Iterable<ServerInfo> getConnections() {
        return this.m_serverCollection;
    }

    @Override
    public synchronized Iterable<DatabaseInfo> getDatabases(ServerInfo server) {
        Collection<DatabaseInfo> databases = this.m_databaseMap.get(server);
        ArrayList<DatabaseInfo> returnSet = new ArrayList<DatabaseInfo>();
        if (databases != null) {
            returnSet.addAll(databases);
        }
        return returnSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterDatabases(Iterable<DatabaseInfo> databases, ContainerFilter containerFilter, DatabaseFilter databaseFilter, ListenerOp listenerOp, CollectionOp collectionOp) {
        HashMap newServerDatabaseMap = new HashMap();
        ArrayList<DatabaseInfo> paramDatabaseSet = new ArrayList<DatabaseInfo>();
        ArrayList<ApplicationListener> localListenersCopy = new ArrayList<ApplicationListener>();
        ApplicationImpl applicationImpl = this;
        synchronized (applicationImpl) {
            for (DatabaseInfo databaseInfo : databases) {
                Collection<DatabaseInfo> databasesForServer = this.m_databaseMap.get(databaseInfo.getServer());
                if (databasesForServer == null || !containerFilter.test(databasesForServer, databaseInfo) || !databaseFilter.test(databaseInfo)) continue;
                if (!newServerDatabaseMap.containsKey(databaseInfo.getServer())) {
                    newServerDatabaseMap.put(databaseInfo.getServer(), new HashSet());
                }
                ((Collection)newServerDatabaseMap.get(databaseInfo.getServer())).add(databaseInfo);
            }
            for (Map.Entry entry : newServerDatabaseMap.entrySet()) {
                collectionOp.doOp(this.m_databaseMap.get(entry.getKey()), (Collection)entry.getValue());
                paramDatabaseSet.addAll((Collection)entry.getValue());
            }
            localListenersCopy.addAll(this.m_listeners);
        }
        for (ApplicationListener listener : localListenersCopy) {
            listenerOp.doOp(listener, paramDatabaseSet);
        }
    }

    @Override
    public void addDatabases(final ServerInfo info, Collection<DatabaseInfo> databases) {
        ContainerFilter containerFilter = new ContainerFilter(){

            @Override
            public boolean test(Collection<DatabaseInfo> databases, DatabaseInfo database) {
                return !databases.contains(database);
            }
        };
        DatabaseFilter databaseFilter = new DatabaseFilter(){

            @Override
            public boolean test(DatabaseInfo database) {
                return database.getName().toUpperCase().equals(database.getName());
            }
        };
        CollectionOp collectionOp = new CollectionOp(){

            @Override
            public void doOp(Collection<DatabaseInfo> baseDatabases, Collection<DatabaseInfo> parameterData) {
                baseDatabases.addAll(parameterData);
            }
        };
        ListenerOp listenerOp = new ListenerOp(){

            @Override
            public void doOp(ApplicationListener listener, Collection<DatabaseInfo> paramDatabases) {
                ((Collection)ApplicationImpl.this.m_databaseMap.get(info)).addAll(paramDatabases);
                listener.databasesAdded(paramDatabases);
            }
        };
        this.filterDatabases(databases, containerFilter, databaseFilter, listenerOp, collectionOp);
    }

    @Override
    public void deleteDatabases(Iterable<DatabaseInfo> databases) {
        ContainerFilter containerFilter = new ContainerFilter(){

            @Override
            public boolean test(Collection<DatabaseInfo> databases, DatabaseInfo database) {
                return databases.contains(database);
            }
        };
        DatabaseFilter databaseFilter = new DatabaseFilter(){

            @Override
            public boolean test(DatabaseInfo database) {
                return true;
            }
        };
        CollectionOp collectionOp = new CollectionOp(){

            @Override
            public void doOp(Collection<DatabaseInfo> baseDatabases, Collection<DatabaseInfo> parameterData) {
                baseDatabases.removeAll(parameterData);
            }
        };
        ListenerOp listenerOp = new ListenerOp(){

            @Override
            public void doOp(ApplicationListener listener, Collection<DatabaseInfo> paramDatabases) {
                listener.databasesDeleted(paramDatabases);
            }
        };
        this.filterDatabases(databases, containerFilter, databaseFilter, listenerOp, collectionOp);
    }

    @Override
    public void onExtentionLoaded(ExtentionManager extentions) {
        for (String res : extentions.getExtentionResources("strings")) {
            StringLocalizer.importStrings(res);
        }
        for (String res : extentions.getExtentionResources("actions")) {
            ActionLogicManagerImpl.inst().merge(ActionLoader.loadFromResource(res));
        }
    }

    @Override
    public void addSchemaInfo(File jar) {
        try {
            DynamicClassLoader.addFile(jar);
            this.m_schemaMap.add(new JarFile(jar));
            ProductInfo info = ProductInfoImpl.extractFromJarFile(jar);
            if (info != null) {
                this.m_suiteMap.addProductInfo(info);
            }
        }
        catch (IOException e) {
            DBMTLogger.error(Channel.USER, StringLocalizer.get("dbmt.schemaloader.unabletoloadjar", new String[]{jar.getAbsolutePath()}));
        }
    }

    @Override
    public List<ParameterizedJobFactory<?>> getSchemaSteps(SchemaInfo schema, ActionClass action) {
        return this.m_schemaMap.get(schema, action);
    }

    @Override
    public List<ProductInfo> getSuiteInfo(ProductSuiteType type) {
        return this.m_suiteMap.getAvailableSuites(type);
    }

    @Override
    public ProductInfo getCurrentSuiteInfo(ProductSuiteType type) {
        List<ProductInfo> productInfoList = this.getSuiteInfo(type);
        if (productInfoList == null) {
            return null;
        }
        ProductInfo latestProductInfo = null;
        for (ProductInfo pInfo : productInfoList) {
            if (latestProductInfo != null && latestProductInfo.getVersion().compareTo(pInfo.getVersion()) >= 0) continue;
            latestProductInfo = pInfo;
        }
        return latestProductInfo;
    }

    public static interface ListenerOp {
        public void doOp(ApplicationListener var1, Collection<DatabaseInfo> var2);
    }

    public static interface DatabaseFilter {
        public boolean test(DatabaseInfo var1);
    }

    public static interface ContainerFilter {
        public boolean test(Collection<DatabaseInfo> var1, DatabaseInfo var2);
    }

    public static interface CollectionOp {
        public void doOp(Collection<DatabaseInfo> var1, Collection<DatabaseInfo> var2);
    }
}

